set more off
pause off
set level 90

graph set window fontface "Times New Roman"
cap log close

sort gvkeyn qdate

if "$response" == "realppentq"  | "$response" == "logppentq" {

gen Trim_ppentq = .
sort qdate
by qdate: egen Threshold99 = pctile(ppentq) if ppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(ppentq) if ppentq ! = ., p(1)

replace Trim_ppentq = 1 if ppentq > Threshold99 & ppentq ! = .
replace Trim_ppentq = 1 if ppentq < Threshold1 & ppentq ! = .

cap drop Threshold*

by qdate: egen Threshold99 = pctile(drealppentq) if drealppentq ! = ., p(99)
by qdate: egen Threshold1 = pctile(drealppentq) if drealppentq ! = ., p(1)

drop if Trim_ppentq == 1  

}

sort gvkeyn qdate
set more off
global HORIZON  = 20 

by gvkeyn : gen firmlife = _N
global LAGS =  4 

cap drop f*
cap drop lag*


if "$response" == "invratio" {
	
drop if cyear < 1986

global rscalelabelmainx "yscale(r(-1 0.5)) ylabel(-1(0.5)0.5, labsize(large))" 

}

sort gvkeyn qdate

foreach y in $response {

	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'

	}
}

* this is used for common sample only.
foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}

foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}

foreach y in $controls {	
		
	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}

sort gvkeyn qdate
gen horizon = _n - 1 if _n<= $HORIZON + 1


*********
*** GENERATING THE EMPTY VARIABLES TO STORE COEFFICIENTS AND STD ERRORS
*********
	
	foreach y in $response {	
	forval k = 1/$nq {
	
	gen ir`k'_`y'_IV = .
	gen se`k'_`y'_IV = .
	
	gen ir`k'_`y'_IVp = .
	gen ir`k'_`y'_IVn = .
	gen se`k'_`y'_IVp = .
	gen se`k'_`y'_IVn = .

	}
	}
	

reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)

gen dum2001 = 0
replace dum2001 = 1 if cyear == 2001 

gen dum2008 = 0
replace dum2008 = 1 if cyear == 2008

gen dum1981 = 0
replace dum1981 = 1 if cyear == 1981

*************
****** Produces Appendix Table B.5. Estimates
*************

foreach y in $response {

foreach h in 10 {  //  0 4 8 10 12 16

ivreghdfe f`h'`y' $lagsAll Trend (c.${npolicy_variable_l} c.${npolicy_variable_s} c.${ppolicy_variable_l} c.${ppolicy_variable_s} ///
= c.${ninstrument_l} c.${ninstrument_s} c.${pinstrument_l} c.${pinstrument_s}) if samp == 1, cluster(qdate gvkeyn) absorb(gvkeyn) bw(16)
 
ereturn display 

matrix rtablebase`h'=r(table)
matrix list rtablebase`h'

}
}

